(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4074,        127]*)
(*NotebookOutlinePosition[      4780,        152]*)
(*  CellTagsIndexPosition[      4736,        148]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  StyleBox["a) ",
    FontWeight->"Bold"],
  "Calcula las soluciones del sistema de ecuaciones lineales  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", GridBox[{
              {\(x + y = \(-1\)\)},
              {\(10  x + \((55/10 - \ t)\) y = 0\)}
              }]}], TraditionalForm]]],
  "   para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`t = \(-10\), \(-9\),  ... , 9, 10\)]],
  ".\nSugerencia. Puedes usar Table[Solve[ ], {i,-10,10}].\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  "Haz una representaci\[OAcute]n gr\[AAcute]fica de la soluci\[OAcute]n del \
sistema de ecuaciones lineales  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", GridBox[{
              {\(x + 3  y = \(-1\)\)},
              {\(x\  - y = 1\)}
              }]}], TraditionalForm]]],
  "  En dicha representaci\[OAcute]n deben aparecer las dos rectas \
representadas por las ecuaciones y su punto de intersecci\[OAcute]n en rojo \
con tama\[NTilde]o apropiado.\n",
  StyleBox[" c) ",
    FontWeight->"Bold"],
  "Aprovecha el trabajo hecho en",
  StyleBox[" b) ",
    FontWeight->"Bold"],
  "para hacer una animaci\[OAcute]n para ver la variaci\[OAcute]n de la \
soluci\[OAcute]n obtenida en el apartado ",
  StyleBox["a)",
    FontWeight->"Bold"],
  " en funci\[OAcute]n de la variaci\[OAcute]n del par\[AAcute]metro ",
  StyleBox["t",
    FontSlant->"Italic"],
  ". "
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Dado un n\[UAcute]mero x>0, se puede consguir que la suma  ",
  StyleBox["1/1 + 1/2 + 1/3 + 1/4 + ...+1/n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["  sea mayor que x ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times New Roman"],
  "tomando un n\[UAcute]mero ",
  StyleBox["n",
    FontFamily->"Courier"],
  " suficientemente grande. Define una funci\[OAcute]n que calcule el primer \
n\[UAcute]mero ",
  StyleBox["n",
    FontFamily->"Courier"],
  " que satisface dicha condici\[OAcute]n. Calcula ",
  StyleBox["n",
    FontFamily->"Courier"],
  " para x=10,11,13. \nSugerencia. Debes evitar que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcule simb\[OAcute]licamente."
}], "ExerciseText"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{978, 611},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 31, 0, 48, "Exercise"],
Cell[1765, 53, 1416, 40, 186, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3218, 98, 31, 0, 48, "Exercise"],
Cell[3252, 100, 806, 24, 83, "ExerciseText"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

